﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using IndianHealthService.BMXNet.WinForm.Configuration;

namespace IndianHealthService.BMXNet.WinForm.Forms
{
    internal partial class RpmsServerConfigurationManagementDialog : Form
    {
        public RpmsServerConfigurationManagementDialog()
        {
            InitializeComponent();
        }

        private RpmsConnectionSettings _settings = null;

        public RpmsConnectionSettings Settings
        {
            get { return _settings; }
            set { _settings = value; }
        }


        public void UpdateListView(RpmsConnectionSpec aSpec)
        {
            this.specListView.BeginUpdate();
            this.specListView.Items.Clear();
            this.specListView.Columns.Clear();

            this.specListView.Columns.Add("Connection", 140);
            this.specListView.Columns.Add("Server:Port", 100);
            this.specListView.Columns.Add("Namespace", 120);
            this.specListView.Columns.Add("Authenication", 120);

            foreach (RpmsConnectionSpec each in this.Settings.ManagedConnectionSpecs)
            {
                ListViewItem item = new ListViewItem(each.Name);
                item.UseItemStyleForSubItems=false;
                if (each.IsDefault) {
                    item.Font = new Font(this.specListView.Font, FontStyle.Bold);
                    item.Text = item.Text + " (default)";
                }
                item.SubItems.Add(each.Server + ":" + each.Port.ToString());
                item.SubItems.Add(each.HasNameSpace ? each.NameSpace : "(RPMS default)");
                item.SubItems.Add(each.UseWindowsAuthentication ? "RPMS/Windows" : "RPMS");
                item.Tag = each;
                item.Selected = each==aSpec;

                this.specListView.Items.Add(item);
            }

            this.specListView.EndUpdate();

            this.UpdateCues();
        }

        private void RpmsServerConfigurationManagementDialog_Load(object sender, EventArgs e)
        {
            this.Icon = this.Owner.Icon;
            this.UpdateListView(null);
        }

        private void newButton_Click(object sender, EventArgs e)
        {
            RpmsServerConnectionPropertiesDialog dialog = new RpmsServerConnectionPropertiesDialog();
            dialog.Model = new RpmsConnectionSpec();
            dialog.ShowDialog(this);
            if (dialog.Model == null)
                return;

            this.Settings.AddConnectionSpec(dialog.Model);
            this.UpdateListView(dialog.Model);

        }

        private void saveButton_Click(object sender, EventArgs e)
        {
            this.Settings.Save();
            this.Close();
        }

        private void specListView_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.UpdateCues();
        }

        public RpmsConnectionSpec SelectedSpec
        {
            get
            {
                if (this.specListView.SelectedItems.Count > 0)
                {
                    return (RpmsConnectionSpec)this.specListView.SelectedItems[0].Tag;
                }
                else
                {
                    return null;
                }
            }
        }

        protected void UpdateCues()
        {
            bool hasSelection = this.SelectedSpec != null;

            this.deleteButton.Enabled = hasSelection;
            this.editButton.Enabled = hasSelection;
            this.moveDownButton.Enabled = hasSelection;
            this.moveUpButton.Enabled = hasSelection;
            this.beDefaultButton.Enabled = hasSelection;
            this.testButton.Enabled = hasSelection;
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Settings.Revert();
            this.Close();
        }

        private void moveUpButton_Click(object sender, EventArgs e)
        {
            RpmsConnectionSpec spec = this.SelectedSpec;

            if (spec != null)
            {
                if (this.Settings.MoveConnectionSpecUp(spec))
                {
                    this.UpdateListView(spec);
                }
            }
        }

        private void moveDownButton_Click(object sender, EventArgs e)
        {
            RpmsConnectionSpec spec = this.SelectedSpec;

            if (spec != null)
            {
                if (this.Settings.MoveConnectionSpecDown(spec))
                {
                    this.UpdateListView(spec);
                }
            }
        }

        private void beDefaultButton_Click(object sender, EventArgs e)
        {
            RpmsConnectionSpec spec = this.SelectedSpec;

            if (spec != null)
            {
                this.Settings.SetConnectionSpecAsDefault(spec);
                this.UpdateListView(spec);
            }
        }

        private void deleteButton_Click(object sender, EventArgs e)
        {
            RpmsConnectionSpec spec = this.SelectedSpec;

            if (spec != null)
            {
                this.Settings.RemoveConnectionSpec(spec);
                this.UpdateListView(null);
            }
        }

        private void editButton_Click(object sender, EventArgs e)
        {
            RpmsConnectionSpec spec = this.SelectedSpec;

            if (spec != null)
            {
                RpmsServerConnectionPropertiesDialog dialog = new RpmsServerConnectionPropertiesDialog();
                dialog.Model = spec;
                dialog.ShowDialog();
                if (dialog.Model == null)
                    return;

                if (dialog.Model.IsDefault)
                {
                    this.Settings.SetConnectionSpecAsDefault(dialog.Model);
                }
                this.UpdateListView(dialog.Model);
            }
        }

        private void testButton_Click(object sender, EventArgs e)
        {           
            RpmsConnectionSpec selectedSpec = this.SelectedSpec;

            if (selectedSpec == null)
                return;

            RpmsConnectionSpec testSpec = new RpmsConnectionSpec();
            testSpec.Name = selectedSpec.Name;
            testSpec.Server = selectedSpec.Server;
            testSpec.Port = selectedSpec.Port;
            testSpec.NameSpace = selectedSpec.NameSpace;
            testSpec.IsDefault = true; //This is so auth will work
            testSpec.UseWindowsAuthentication = selectedSpec.UseWindowsAuthentication;

            ConnectionTest test = new ConnectionTest();
            test.UiOwner = this;

            test.Test(testSpec);
  
        }


    }
}
